
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <button onclick="startFCM()" class="btn btn-danger btn-flat">Allow notification
                </button>
                <div class="card mt-3">
                    <div class="card-body">
                        @if (session('status'))
                            <div class="alert alert-success" role="alert">
                                {{ session('status') }}
                            </div>
                        @endif
                        <form action="{{ route('admin.notifications.send') }}" method="POST">
                            @csrf
                            <div class="form-group">
                                <label>Message Title</label>
                                <input type="text" class="form-control" name="title">
                            </div>
                            <div class="form-group">
                                <label>Message Body</label>
                                <textarea class="form-control" name="body"></textarea>
                            </div>
                            <button type="submit" class="btn btn-success btn-block">Send Notification</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- The core Firebase JS SDK is always required and must be listed first -->
    {{-- <script src="https://www.gstatic.com/firebasejs/9.6.5/firebase-messaging-compat.js"></script> --}}
    <script src="https://www.gstatic.com/firebasejs/9.6.5/firebase-app-compat.js"></script>
    <script src="https://www.gstatic.com/firebasejs/9.6.5/firebase-messaging-compat.js"></script>

    <script>
        var firebaseConfig = {
            apiKey: "AIzaSyDGZep9UYMKb5hubx4ZXWc1C97Z0YREpBU",
            authDomain: "zain-clinic.firebaseapp.com",
            projectId: "zain-clinic",
            storageBucket: "zain-clinic.appspot.com",
            messagingSenderId: "479149046768",
            appId: "1:479149046768:web:f0cda4c8d5eca1f1393b35",
        };

        firebase.initializeApp(firebaseConfig);
        const messaging = firebase.messaging();

        function startFCM() {
            messaging
                .requestPermission()
                .then(function() {
                    return messaging.getToken()
                })
                .then(function(response) {
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    });
                    $.ajax({
                        url: '{{ route("admin.notifications.save_token") }}',
                        type: 'POST',
                        data: {
                            token: response
                        },
                        dataType: 'JSON',
                        success: function(response) {
                            alert('Token stored.');
                        },
                        error: function(error) {
                            alert(error);
                        },
                    });

                }).catch(function(error) {
                    alert(error);
                });
        }

        messaging.onMessage(function(payload) {
            const title = payload.notification.title;
            const options = {
                body: payload.notification.body,
                icon: payload.notification.icon,
            };
            new Notification(title, options);
        });
    </script>
